import datetime
from typing import Tuple
import pandas as pd


def doy_to_date(doy, year):
    return pd.to_datetime(
        f'{year}-01-01') + pd.Timedelta(days=doy-1)


def get_processing_dates(start_month: int,
                         end_month: int,
                         year: int) -> Tuple[str, str]:
    """Convert start and end months
        into processing dates based on a reference year

        Args:
            start_doy (int): start day of year
            end_doy (int): end day of year
            year (int): reference year in which season ends

        Returns:
            tuple(str, str): start and end processing dates
        """
    if start_month < end_month:
        # start is in same year as end
        start_date = pd.to_datetime(datetime.date(year, start_month, 1))
    else:
        # start date is in previous year
        start_date = pd.to_datetime(datetime.date(year - 1, start_month, 1))

    end_date = datetime.date(year + (end_month == 12),
                             (end_month + 1 if end_month < 12 else 1),
                             1) - datetime.timedelta(1)

    return start_date.strftime('%Y-%m-%d'), end_date.strftime('%Y-%m-%d')
